/*
 * Decompiled with CFR 0.152.
 */
package fer.lss.lecto.services.translate;

import fer.lss.lecto.LeCTo;
import fer.lss.lecto.constants.LeCToConstants;
import fer.lss.lecto.constants.LinuxConstants;
import fer.lss.lecto.constants.MacOSXConstants;
import fer.lss.lecto.constants.WindowsConstants;
import fer.lss.lecto.gui.locale.LeCToLocale;
import fer.lss.lecto.services.MessagesService;
import fer.lss.lecto.utils.FilesUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

public class TranslateService {
    public static void saveNewLanguage(Properties languageProperties, String countryInitials, String languageInitials, String countryIconPath) throws IOException {
        File languageFolder;
        switch (LeCTo.operatingSystem.getFamily()) {
            case WINDOWS: {
                languageFolder = new File(String.valueOf(WindowsConstants.LECTO_LANGUAGES_FOLDER_LOCATION) + File.separator + languageInitials + "_" + countryInitials);
                break;
            }
            case LINUX: {
                languageFolder = new File(String.valueOf(LinuxConstants.LECTO_LANGUAGES_FOLDER_LOCATION) + File.separator + languageInitials + "_" + countryInitials);
                break;
            }
            case MAC: {
                languageFolder = new File(String.valueOf(MacOSXConstants.LECTO_LANGUAGES_FOLDER_LOCATION) + File.separator + languageInitials + "_" + countryInitials);
                break;
            }
            default: {
                return;
            }
        }
        languageFolder.mkdirs();
        String languagePropertiesFileName = LeCToConstants.LANGUAGE_PROPERTIES_FILE_NAME;
        String iconFlagFileName = LeCToConstants.COUNTRY_FLAG_ICON_NAME;
        File propertiesFile = new File(String.valueOf(languageFolder.getAbsolutePath()) + File.separator + languagePropertiesFileName);
        File iconFile = new File(String.valueOf(languageFolder.getAbsolutePath()) + File.separator + iconFlagFileName);
        Locale locale = new Locale(languageInitials, countryInitials);
        LeCToLocale leCToLocale = new LeCToLocale(locale, iconFile.getAbsolutePath(), LeCToLocale.LeCToLocaleType.CUSTOM);
        leCToLocale.setCustomLocaleMessagesPropertiesFile(propertiesFile);
        FilesUtil.savePropertiesToFile(languageProperties, propertiesFile);
        FilesUtil.copyFile(new File(countryIconPath), iconFile);
        MessagesService.addCustomLocale(leCToLocale);
    }

    public static List<LeCToLocale> getCustomLocales() {
        File[] languages;
        File languagesFolder;
        switch (LeCTo.operatingSystem.getFamily()) {
            case WINDOWS: {
                languagesFolder = new File(WindowsConstants.LECTO_LANGUAGES_FOLDER_LOCATION);
                break;
            }
            case LINUX: {
                languagesFolder = new File(LinuxConstants.LECTO_LANGUAGES_FOLDER_LOCATION);
                break;
            }
            case MAC: {
                languagesFolder = new File(MacOSXConstants.LECTO_LANGUAGES_FOLDER_LOCATION);
                break;
            }
            default: {
                return null;
            }
        }
        languagesFolder.mkdirs();
        ArrayList<LeCToLocale> customLocales = new ArrayList<LeCToLocale>();
        File[] fileArray = languages = languagesFolder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.matches("[a-zA-Z]+_[a-zA-Z]+");
            }
        });
        int n2 = languages.length;
        int n3 = 0;
        while (n3 < n2) {
            File language = fileArray[n3];
            File[] iconFileArray = language.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.equals(LeCToConstants.COUNTRY_FLAG_ICON_NAME);
                }
            });
            File[] languagePropertiesFileArray = language.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.equals(LeCToConstants.LANGUAGE_PROPERTIES_FILE_NAME);
                }
            });
            if (iconFileArray != null && languagePropertiesFileArray != null && iconFileArray.length == 1 && languagePropertiesFileArray.length == 1) {
                File iconFile = iconFileArray[0];
                File languagePropertiesFile = languagePropertiesFileArray[0];
                String languageName = language.getName();
                Locale locale = new Locale(languageName.split("_")[0], languageName.split("_")[1]);
                LeCToLocale leCToLocale = new LeCToLocale(locale, iconFile.getAbsolutePath(), LeCToLocale.LeCToLocaleType.CUSTOM);
                leCToLocale.setCustomLocaleMessagesPropertiesFile(languagePropertiesFile);
                customLocales.add(leCToLocale);
            }
            ++n3;
        }
        return customLocales;
    }

    public static LeCToLocale getLeCToCustomLocale(String localeName) {
        File languageFile;
        switch (LeCTo.operatingSystem.getFamily()) {
            case WINDOWS: {
                languageFile = new File(String.valueOf(WindowsConstants.LECTO_LANGUAGES_FOLDER_LOCATION) + File.separator + localeName);
                break;
            }
            case LINUX: {
                languageFile = new File(String.valueOf(LinuxConstants.LECTO_LANGUAGES_FOLDER_LOCATION) + File.separator + localeName);
                break;
            }
            case MAC: {
                languageFile = new File(String.valueOf(MacOSXConstants.LECTO_LANGUAGES_FOLDER_LOCATION) + File.separator + localeName);
                break;
            }
            default: {
                return null;
            }
        }
        if (languageFile.exists()) {
            Locale locale = new Locale(languageFile.getName().split("_")[0], languageFile.getName().split("_")[1]);
            String iconPath = String.valueOf(languageFile.getAbsolutePath()) + File.separator + LeCToConstants.COUNTRY_FLAG_ICON_NAME;
            LeCToLocale leCToLocale = new LeCToLocale(locale, iconPath, LeCToLocale.LeCToLocaleType.CUSTOM);
            File propsFile = new File(String.valueOf(languageFile.getAbsolutePath()) + File.separator + LeCToConstants.LANGUAGE_PROPERTIES_FILE_NAME);
            leCToLocale.setCustomLocaleMessagesPropertiesFile(propsFile);
            return leCToLocale;
        }
        return null;
    }

    public static void importLangugeFromLLPZIPArchive(File leCToLanguagePack) throws IOException {
        File outFile;
        String languageFolderName = leCToLanguagePack.getName().substring(0, leCToLanguagePack.getName().indexOf(LeCToConstants.LECTO_LANGUAGE_PACK_FILE_EXTENSION));
        switch (LeCTo.operatingSystem.getFamily()) {
            case WINDOWS: {
                outFile = new File(String.valueOf(WindowsConstants.LECTO_LANGUAGES_FOLDER_LOCATION) + File.separator + languageFolderName);
                break;
            }
            case LINUX: {
                outFile = new File(String.valueOf(LinuxConstants.LECTO_LANGUAGES_FOLDER_LOCATION) + File.separator + languageFolderName);
                break;
            }
            case MAC: {
                outFile = new File(String.valueOf(MacOSXConstants.LECTO_LANGUAGES_FOLDER_LOCATION) + File.separator + languageFolderName);
                break;
            }
            default: {
                return;
            }
        }
        outFile.mkdirs();
        FilesUtil.extractFromZipArchiveToFile(leCToLanguagePack, outFile);
        String languagePropertiesFileName = LeCToConstants.LANGUAGE_PROPERTIES_FILE_NAME;
        String iconFlagFileName = LeCToConstants.COUNTRY_FLAG_ICON_NAME;
        File propertiesFile = new File(String.valueOf(outFile.getAbsolutePath()) + File.separator + languagePropertiesFileName);
        Locale locale = new Locale(languageFolderName.split("_")[0], languageFolderName.split("_")[1]);
        LeCToLocale leCToLocale = new LeCToLocale(locale, String.valueOf(outFile.getAbsolutePath()) + File.separator + iconFlagFileName, LeCToLocale.LeCToLocaleType.CUSTOM);
        leCToLocale.setCustomLocaleMessagesPropertiesFile(propertiesFile);
        MessagesService.addCustomLocale(leCToLocale);
    }

    public static void exportLanguageToLLPZipFile(LeCToLocale leCToLocale, File location) throws IOException {
        File iconFile;
        File propsFile;
        block0 : switch (leCToLocale.getLeCToLocaleType()) {
            case DEFAULT: {
                switch (LeCTo.operatingSystem.getFamily()) {
                    case WINDOWS: {
                        Properties props = MessagesService.getProperties(leCToLocale.getLocale());
                        propsFile = new File(String.valueOf(WindowsConstants.FILES_TEMP_FOLDER) + File.separator + LeCToConstants.LANGUAGE_PROPERTIES_FILE_NAME);
                        FilesUtil.savePropertiesToFile(props, propsFile);
                        iconFile = new File(String.valueOf(WindowsConstants.FILES_TEMP_FOLDER) + File.separator + LeCToConstants.COUNTRY_FLAG_ICON_NAME);
                        FilesUtil.copyResourceToFile(leCToLocale.getIconPath(), iconFile);
                        break block0;
                    }
                    case LINUX: {
                        Properties props = MessagesService.getProperties(leCToLocale.getLocale());
                        propsFile = new File(String.valueOf(LinuxConstants.FILES_TEMP_FOLDER) + File.separator + LeCToConstants.LANGUAGE_PROPERTIES_FILE_NAME);
                        FilesUtil.savePropertiesToFile(props, propsFile);
                        iconFile = new File(String.valueOf(LinuxConstants.FILES_TEMP_FOLDER) + File.separator + LeCToConstants.COUNTRY_FLAG_ICON_NAME);
                        FilesUtil.copyResourceToFile(leCToLocale.getIconPath(), iconFile);
                        break block0;
                    }
                    case MAC: {
                        Properties props = MessagesService.getProperties(leCToLocale.getLocale());
                        propsFile = new File(String.valueOf(MacOSXConstants.FILES_TEMP_FOLDER) + File.separator + LeCToConstants.LANGUAGE_PROPERTIES_FILE_NAME);
                        FilesUtil.savePropertiesToFile(props, propsFile);
                        iconFile = new File(String.valueOf(MacOSXConstants.FILES_TEMP_FOLDER) + File.separator + LeCToConstants.COUNTRY_FLAG_ICON_NAME);
                        FilesUtil.copyResourceToFile(leCToLocale.getIconPath(), iconFile);
                        break block0;
                    }
                }
                return;
            }
            case CUSTOM: {
                propsFile = leCToLocale.getCustomLocaleMessagesPropertiesFile();
                iconFile = new File(leCToLocale.getIconPath());
                break;
            }
            default: {
                return;
            }
        }
        File outFile = new File(String.valueOf(location.getAbsolutePath()) + File.separator + leCToLocale.getLocale().toString() + LeCToConstants.LECTO_LANGUAGE_PACK_FILE_EXTENSION);
        FilesUtil.createZipArchive(outFile, propsFile, iconFile);
        switch (leCToLocale.getLeCToLocaleType()) {
            case DEFAULT: {
                propsFile.delete();
                iconFile.delete();
            }
        }
    }

    public static void deleteLanguageFiles(LeCToLocale leCToLocale) {
        File languageFolder;
        switch (LeCTo.operatingSystem.getFamily()) {
            case WINDOWS: {
                languageFolder = new File(String.valueOf(WindowsConstants.LECTO_LANGUAGES_FOLDER_LOCATION) + File.separator + leCToLocale.getLocale().toString());
                break;
            }
            case LINUX: {
                languageFolder = new File(String.valueOf(LinuxConstants.LECTO_LANGUAGES_FOLDER_LOCATION) + File.separator + leCToLocale.getLocale().toString());
                break;
            }
            case MAC: {
                languageFolder = new File(String.valueOf(MacOSXConstants.LECTO_LANGUAGES_FOLDER_LOCATION) + File.separator + leCToLocale.getLocale().toString());
                break;
            }
            default: {
                return;
            }
        }
        File[] fileArray = languageFolder.listFiles();
        int n2 = fileArray.length;
        int n3 = 0;
        while (n3 < n2) {
            File file = fileArray[n3];
            file.delete();
            ++n3;
        }
        MessagesService.removeCustomLocale(leCToLocale);
        languageFolder.delete();
    }
}

