/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.input.ClosedInputStream;
import org.apache.commons.io.input.ProxyInputStream;

public class AutoCloseInputStream
extends ProxyInputStream {
    public AutoCloseInputStream(InputStream in) {
        super(in);
    }

    public void close() throws IOException {
        this.in.close();
        this.in = new ClosedInputStream();
    }

    public int read() throws IOException {
        int n2 = this.in.read();
        if (n2 == -1) {
            this.close();
        }
        return n2;
    }

    public int read(byte[] b2) throws IOException {
        int n2 = this.in.read(b2);
        if (n2 == -1) {
            this.close();
        }
        return n2;
    }

    public int read(byte[] b2, int off, int len) throws IOException {
        int n2 = this.in.read(b2, off, len);
        if (n2 == -1) {
            this.close();
        }
        return n2;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

