/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingbinding.adapters;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComboBox;
import javax.swing.JList;
import org.jdesktop.beansbinding.ext.BeanAdapterProvider;
import org.jdesktop.swingbinding.adapters.BeanAdapterBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JComboBoxAdapterProvider
implements BeanAdapterProvider {
    private static final String SELECTED_ITEM_P = "selectedItem";

    @Override
    public boolean providesAdapter(Class<?> type, String property) {
        return JComboBox.class.isAssignableFrom(type) && property.intern() == SELECTED_ITEM_P;
    }

    @Override
    public Object createAdapter(Object source, String property) {
        if (!this.providesAdapter(source.getClass(), property)) {
            throw new IllegalArgumentException();
        }
        return new Adapter((JComboBox)source);
    }

    @Override
    public Class<?> getAdapterClass(Class<?> type) {
        return JList.class.isAssignableFrom(type) ? Adapter.class : null;
    }

    public static final class Adapter
    extends BeanAdapterBase {
        private JComboBox combo;
        private Handler handler;
        private Object cachedItem;

        private Adapter(JComboBox combo) {
            super(JComboBoxAdapterProvider.SELECTED_ITEM_P);
            this.combo = combo;
        }

        public Object getSelectedItem() {
            return this.combo.getSelectedItem();
        }

        public void setSelectedItem(Object item) {
            this.combo.setSelectedItem(item);
        }

        protected void listeningStarted() {
            this.handler = new Handler();
            this.cachedItem = this.combo.getSelectedItem();
            this.combo.addActionListener(this.handler);
            this.combo.addPropertyChangeListener("model", this.handler);
        }

        protected void listeningStopped() {
            this.combo.removeActionListener(this.handler);
            this.combo.removePropertyChangeListener("model", this.handler);
            this.handler = null;
            this.cachedItem = null;
        }

        private class Handler
        implements ActionListener,
        PropertyChangeListener {
            private Handler() {
            }

            private void comboSelectionChanged() {
                Object oldValue = Adapter.this.cachedItem;
                Adapter.this.cachedItem = Adapter.this.getSelectedItem();
                Adapter.this.firePropertyChange(oldValue, Adapter.this.cachedItem);
            }

            public void actionPerformed(ActionEvent ae2) {
                this.comboSelectionChanged();
            }

            public void propertyChange(PropertyChangeEvent pce) {
                this.comboSelectionChanged();
            }
        }
    }
}

